import sys  #Importa il modulo sys, che permette di accedere agli argomenti
            #passati al programma da riga di comando (sys.argv)
from sense_hat import SenseHat #Importa la classe SenseHat per controllare la scheda
import time # Importa il modulo time, non usato nel programma

sense = SenseHat() #Crea l'oggetto SenseHat per comunicare con la Sense HAT

colore_input = sys.argv[1] #Legge il primo argomento passato da riga di comando
velocita = int(sys.argv[2])#Legge il secondo argomento e lo converte in intero
testo = sys.argv[3]        #Legge il terzo argomento passato al programma

if colore_input == "rosso":  #Se l'utente scrive "rosso", imposta il colore rosso
    colore_rgb = (255, 0, 0)
elif colore_input == "verde":#Se l'utente scrive "verde", imposta il colore verde
    colore_rgb = (0, 255, 0)
elif colore_input == "blu":  #Se l'utente scrive "blu", imposta il colore blu
    colore_rgb = (0, 0, 255)
elif colore_input == "bianco": #Se l'utente scrive "bianco", imposta il colore bianco
    colore_rgb = (255, 255, 255)
else:
    colore_rgb = (255, 255, 255)#Se il colore inserito non è riconosciuto, usa il bianco
    
# Mostra testo scorrevole e converte la velocità da millisecondi a secondi
sense.show_message(testo,scroll_speed=velocita / 1000.0,text_colour=colore_rgb)
print("scritta eseguita="   # Stampa un messaggio di conferma a console
print(testo)                # Stampa il testo che è stato mostrato
print("colore=")            # Stampa l'etichetta del colore
print(colore_input)         # Stampa il colore scelto dall'utente




